// Scilab Version: 6.0.1
//O.S : Windows 10
//Continuous Time Fourier Transform of h(t)=exp(-At)u(t), t>0
clear ;
clc ;
close ;
// Analog Signal
A =1; // Amplitude
Dt= 0.005;
t=0:Dt:10;
ht=exp(-A*t);
// Cont inuous􀀀time Fourier Transform
Wmax=2*%pi*1; // Analog Frequency = 1Hz
K=4;
k=0:(K/1000):K;
W=k*Wmax/K;
HW=ht*exp(-sqrt(-1)*t'*W)*Dt;
HW_Mag=abs(HW);
W=[-mtlb_fliplr(W),W(2:1001)]; // Omega from Wmax to Wmax
HW_Mag=[ mtlb_fliplr(HW_Mag),HW_Mag(2:1001)];
//Plotting Continuous Time Signal
subplot(1,2,1);
a=gca ();
a.y_location="origin";
plot(t,ht);
xgrid(4,1,7);
xlabel("Time");
ylabel("Amplitude");
title("Input Signal h(t)")
//Plotting Magnitude Responseof CTS
subplot(1,2,2);
a=gca();
a.y_location="origin";
plot(W,HW_Mag);
xgrid(4,1,7);
xlabel("Frequency in red/sec");
ylabel("Amplitude");
title("Frequency Response");
